unit fFilteredSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, uEstSearchDialog, uEstSearchDialogAdo, DB, StdCtrls, dMain;

type
  TFrmFilteredSearch = class(TForm)
    lblKlantnaamMoetBevatten: TLabel;
    edtCustNameMustContain: TEdit;
    btnSearchFiltered: TButton;
    mmoFilteredSearch: TMemo;
    esdFiltered: TEstSearchDialogAdo;
    procedure btnSearchFilteredClick(Sender: TObject);
    procedure esdFilteredFilterRecord(DataSet: TDataSet;
      var Accept: Boolean);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

implementation

{$R *.dfm}

procedure TFrmFilteredSearch.btnSearchFilteredClick(Sender: TObject);
begin
  esdFiltered.Execute;
end;

procedure TFrmFilteredSearch.esdFilteredFilterRecord(DataSet: TDataSet;
  var Accept: Boolean);
begin
  // NL: Filter de dataset ook op dat de naam van het bedrijf de string uit de
  //     edit box moet bevatten
  // EN: Filter the dataset that the company name should also contain the
  //     value from the edit box
  Accept := Pos(Uppercase(edtCustNameMustContain.Text),
                Uppercase(DataSet.FieldByName('company').AsString)) <> 0;
end;

procedure TFrmFilteredSearch.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  Action := caFree;
end;

end.
